#install.packages("neuralnet")
#install.packages("NeuralNetTools")


#library packages
library(neuralnet)
library(NeuralNetTools)
set.seed(123)

inputFile="geneScore.txt"       #input file
setwd("E:\\metabolism\\LGG\\15.ANN\\2.neuralNet")      

#read input file
data=read.table(inputFile, header=T, sep="\t", check.names=F, row.names=1)
data=as.data.frame(t(data))

#Get sample grouping information
group=gsub("(.*)\\_(.*)", "\\2", row.names(data))
data$C1=ifelse(group=="C1", 1, 0)
data$C2=ifelse(group=="C2", 1, 0)

#neural network model
fit=neuralnet(C1+C2~., data, hidden=4)
fit$result.matrix
fit$weight
#plot(fit)

pdf(file="neuralnet.pdf", width=11, height=6)
plotnet(fit)
dev.off()

#Use the model to predict outcomes
net.predict=compute(fit, data)$net.result
net.prediction=c("C1", "C2")[apply(net.predict, 1, which.max)]
predict.table=table(group, net.prediction)
predict.table
conAccuracy=predict.table[1,1]/(predict.table[1,1]+predict.table[1,2])
treatAccuracy=predict.table[2,2]/(predict.table[2,1]+predict.table[2,2])
paste0("C1 accuracy: ", sprintf("%.3f", conAccuracy))
paste0("C2 accuracy: ", sprintf("%.3f", treatAccuracy))

#output prediction result
colnames(net.predict)=c("con", "treat")
outTab=rbind(id=colnames(net.predict), net.predict)
write.table(outTab, file="neural.predict.txt", sep="\t", quote=F, col.names=F)

